/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.samlsso.authenticator;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.user.authentication.BambooAuthenticator;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import de.resolution.samlsso.authenticator.ConfigurableDenyPasswordAuthenticator;
import de.resolution.samlsso.authenticator.DenyPasswordSupport;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BambooDenyPasswordAuthenticator
extends BambooAuthenticator
implements ConfigurableDenyPasswordAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(BambooDenyPasswordAuthenticator.class);
    private DenyPasswordSupport denyPasswordSupport;

    public void init(Map<String, String> params, SecurityConfig config) {
        super.init(params, config);
        this.denyPasswordSupport = new DenyPasswordSupport(params);
    }

    protected boolean authenticate(Principal principal, String password) {
        if (principal == null) {
            logger.error("Principal is null!");
            return false;
        }
        String username = principal.getName();
        if (this.denyPasswordSupport.userOnBlacklist(username)) {
            logger.warn("Denying password access for principal {}, username is on the blacklist.", (Object)username);
            return false;
        }
        if (this.denyPasswordSupport.userOnWhitelist(username)) {
            return super.authenticate(principal, password);
        }
        BambooUserManager bambooUserManager = (BambooUserManager)ContainerManager.getComponent((String)"bambooUserManager", BambooUserManager.class);
        User user = bambooUserManager.getUser(username);
        if (user == null) {
            logger.warn("User {} is null, denying password authentication", (Object)username);
            return false;
        }
        List groupNames = bambooUserManager.getGroupNamesAsList(user);
        if (this.denyPasswordSupport.groupAllowsPasswordLogin(groupNames)) {
            return super.authenticate(principal, password);
        }
        if (!this.isAllowSysAdmins()) {
            logger.warn("Denying password access for principal {}", (Object)username);
            return false;
        }
        BambooPermissionManager bambooPermissionManager = (BambooPermissionManager)ContainerManager.getComponent((String)"bambooPermissionManager", BambooPermissionManager.class);
        if (!bambooPermissionManager.isSystemAdmin(username)) {
            logger.warn("Denying password access for principal {}", (Object)username);
            return false;
        }
        return super.authenticate(principal, password);
    }

    @Override
    public DenyPasswordSupport getDenyPasswordSupport() {
        return this.denyPasswordSupport;
    }
}

