/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.samlsso.authenticator;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceAuthenticator;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.user.User;
import de.resolution.samlsso.authenticator.ConfigurableDenyPasswordAuthenticator;
import de.resolution.samlsso.authenticator.DenyPasswordSupport;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceDenyPasswordAuthenticator
extends ConfluenceAuthenticator
implements ConfigurableDenyPasswordAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceDenyPasswordAuthenticator.class);
    private DenyPasswordSupport denyPasswordSupport;

    public void init(Map<String, String> params, SecurityConfig config) {
        super.init(params, config);
        this.denyPasswordSupport = new DenyPasswordSupport(params);
    }

    protected boolean authenticate(Principal principal, String password) throws AuthenticatorException {
        boolean isAdmin;
        if (principal == null) {
            logger.error("Principal is null!");
            return false;
        }
        String username = principal.getName();
        if (this.denyPasswordSupport.userOnBlacklist(username)) {
            logger.warn("Denying password access for principal {}, username is on the blacklist.", (Object)username);
            return false;
        }
        if (this.denyPasswordSupport.userOnWhitelist(username)) {
            return super.authenticate(principal, password);
        }
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        List groupNames = userAccessor.getGroupNamesForUserName(username);
        if (this.denyPasswordSupport.groupAllowsPasswordLogin(groupNames)) {
            return super.authenticate(principal, password);
        }
        if (!this.isAllowSysAdmins()) {
            logger.warn("Denying password access for principal {}, group memberships deny password login and allowSysadmins is not enabled.", (Object)username);
            return false;
        }
        PermissionManager permissionManager = (PermissionManager)ComponentLocator.getComponent(PermissionManager.class);
        ConfluenceUser user = userAccessor.getUserByName(username);
        if (user == null) {
            logger.debug("User {} was not found", (Object)username);
            return false;
        }
        try {
            isAdmin = permissionManager.isSystemAdministrator(user);
        }
        catch (NoSuchMethodError e) {
            isAdmin = permissionManager.isSystemAdministrator((User)user);
        }
        if (isAdmin) {
            return super.authenticate(principal, password);
        }
        logger.warn("Denying password access for principal {}, group memberships deny password login and user is no sysadmin.", (Object)username);
        return false;
    }

    @Override
    public DenyPasswordSupport getDenyPasswordSupport() {
        return this.denyPasswordSupport;
    }
}

