/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.samlsso.authenticator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenyPasswordSupport {
    private static final Logger logger = LoggerFactory.getLogger(DenyPasswordSupport.class);
    public static final String PARAM_ALLOW_SYSADMINS = "allowSysadmins";
    public static final String PARAM_GROUP_WHITELIST = "allowedGroups";
    public static final String PARAM_GROUP_BLACKLIST = "deniedGroups";
    public static final String PARAM_USER_WHITELIST = "allowedUsers";
    public static final String PARAM_USER_BLACKLIST = "deniedUsers";
    public static final String PARAM_GROUP_ALLOW_OVER_DENY = "groupAllowOverDeny";
    public static final String PARAM_ALLOW_WITHOUT_APPLICATION_ACCESS = "allowWithoutApplicationAccess";
    private final boolean allowSysAdmins;
    private final boolean groupAllowOverDeny;
    private final boolean allowWithoutApplicationAccess;
    private final List<Pattern> groupWhitelist;
    private final List<Pattern> groupBlacklist;
    private final List<Pattern> userWhitelist;
    private final List<Pattern> userBlacklist;

    public DenyPasswordSupport(Map<String, String> params) {
        String blString;
        String wlString;
        String stringValue;
        logger.warn("=========================================================");
        logger.warn("== DenyPasswordAuthenticator is installed on this system.");
        this.allowSysAdmins = params.containsKey(PARAM_ALLOW_SYSADMINS) ? ((stringValue = params.get(PARAM_ALLOW_SYSADMINS)) == null || stringValue.trim().isEmpty() ? true : !stringValue.equalsIgnoreCase("false")) : true;
        if (this.allowSysAdmins) {
            logger.warn("== Users with SysAdmin-privileges can login with their password no matter what groups they are in.");
        } else {
            logger.warn("== Users with SysAdmin-privilege CAN NOT login with their password unless being member of an allowed group!");
        }
        this.allowWithoutApplicationAccess = params.containsKey(PARAM_ALLOW_WITHOUT_APPLICATION_ACCESS) ? ((stringValue = params.get(PARAM_ALLOW_WITHOUT_APPLICATION_ACCESS)) == null || stringValue.trim().isEmpty() ? false : stringValue.equalsIgnoreCase("true")) : false;
        if (this.allowWithoutApplicationAccess) {
            logger.warn("== Jira-Users without application-access (JSM-customers) can use a password.");
        }
        this.groupAllowOverDeny = params.containsKey(PARAM_GROUP_ALLOW_OVER_DENY) ? ((stringValue = params.get(PARAM_GROUP_ALLOW_OVER_DENY)) == null || stringValue.trim().isEmpty() ? false : stringValue.equalsIgnoreCase("true")) : false;
        if (this.groupAllowOverDeny) {
            logger.warn("== Members of an allowed group CAN login even if they are also member of a denied group.");
        } else {
            logger.warn("== Members of an allowed group CAN NOT login if they are also member of a denied group.");
        }
        if (params.containsKey(PARAM_USER_WHITELIST)) {
            wlString = params.get(PARAM_USER_WHITELIST);
            if (wlString != null && !wlString.trim().isEmpty()) {
                this.userWhitelist = Arrays.stream(wlString.split(",")).map(String::trim).map(Pattern::compile).collect(Collectors.toList());
                logger.warn("== User Whitelist: {}", this.getUserWhitelist());
            } else {
                logger.warn("== User Whitelist is empty");
                this.userWhitelist = Collections.emptyList();
            }
        } else {
            logger.warn("== User Whitelist is not configured");
            this.userWhitelist = Collections.emptyList();
        }
        if (params.containsKey(PARAM_USER_BLACKLIST)) {
            blString = params.get(PARAM_USER_BLACKLIST);
            if (blString != null && !blString.trim().isEmpty()) {
                this.userBlacklist = Arrays.stream(blString.split(",")).map(String::trim).map(Pattern::compile).collect(Collectors.toList());
                logger.warn("== User Blacklist: {}", this.getUserBlacklist());
            } else {
                logger.warn("== User Blacklist is empty");
                this.userBlacklist = Collections.emptyList();
            }
        } else {
            logger.warn("== User Blacklist is not configured");
            this.userBlacklist = Collections.emptyList();
        }
        if (params.containsKey(PARAM_GROUP_WHITELIST)) {
            wlString = params.get(PARAM_GROUP_WHITELIST);
            if (wlString != null && !wlString.trim().isEmpty()) {
                this.groupWhitelist = Arrays.stream(wlString.split(",")).map(String::trim).map(Pattern::compile).collect(Collectors.toList());
                logger.warn("== Group Whitelist: {}", this.getGroupWhitelist());
            } else {
                logger.warn("== Group Whitelist is empty");
                this.groupWhitelist = Collections.emptyList();
            }
        } else {
            logger.warn("== Group Whitelist is not configured");
            this.groupWhitelist = Collections.emptyList();
        }
        if (params.containsKey(PARAM_GROUP_BLACKLIST)) {
            blString = params.get(PARAM_GROUP_BLACKLIST);
            if (blString != null && !blString.trim().isEmpty()) {
                this.groupBlacklist = Arrays.stream(blString.split(",")).map(String::trim).map(Pattern::compile).collect(Collectors.toList());
                logger.warn("== Group Blacklist: {}", this.getGroupBlacklist());
            } else {
                logger.warn("== Group Blacklist is empty");
                this.groupBlacklist = Collections.emptyList();
            }
        } else {
            logger.warn("== Group Blacklist is not configured");
            this.groupBlacklist = Collections.emptyList();
        }
        logger.warn("== All other users must use a different method, e.g. SSO to authenticate.");
        if (logger.isErrorEnabled() && this.getUserWhitelist().isEmpty() && this.getGroupBlacklist().isEmpty() && this.getGroupWhitelist().isEmpty() && !this.isAllowSysAdmins()) {
            logger.error("== Group lists and user whitelist are empty and password authentication is also disabled for SysAdmins!");
            logger.error("== PASSWORD ACCESS IS DISABLED FOR ALL USERS, THIS CONFIGURATION IS NOT RECOMMENDED!");
        }
        logger.warn("=======================================================");
    }

    public boolean groupAllowsPasswordLogin(Collection<String> groupsForUser) {
        if (this.groupBlacklist.isEmpty() && this.groupWhitelist.isEmpty()) {
            return false;
        }
        if (this.groupWhitelist.isEmpty()) {
            return groupsForUser.stream().noneMatch(grp -> this.groupBlacklist.stream().anyMatch(pattern -> pattern.matcher((CharSequence)grp).matches()));
        }
        if (this.groupBlacklist.isEmpty() || this.isGroupAllowOverDeny()) {
            return groupsForUser.stream().anyMatch(grp -> this.groupWhitelist.stream().anyMatch(pattern -> pattern.matcher((CharSequence)grp).matches()));
        }
        return groupsForUser.stream().anyMatch(grp -> this.groupWhitelist.stream().anyMatch(pattern -> pattern.matcher((CharSequence)grp).matches())) && groupsForUser.stream().noneMatch(grp -> this.groupBlacklist.stream().anyMatch(pattern -> pattern.matcher((CharSequence)grp).matches()));
    }

    public boolean userOnWhitelist(String username) {
        boolean result = this.userWhitelist.stream().anyMatch(pattern -> pattern.matcher(username).matches());
        if (result) {
            logger.debug("User {} is on the whitelist", (Object)username);
        }
        return result;
    }

    public boolean userOnBlacklist(String username) {
        boolean result = this.userBlacklist.stream().anyMatch(pattern -> pattern.matcher(username).matches());
        if (result) {
            logger.debug("User {} is on the blacklist", (Object)username);
        }
        return result;
    }

    public boolean isAllowSysAdmins() {
        return this.allowSysAdmins;
    }

    public boolean isGroupAllowOverDeny() {
        return this.groupAllowOverDeny;
    }

    public boolean isAllowWithoutApplicationAccess() {
        return this.allowWithoutApplicationAccess;
    }

    public List<String> getGroupWhitelist() {
        return this.groupWhitelist.stream().map(Pattern::toString).collect(Collectors.toList());
    }

    public List<String> getGroupBlacklist() {
        return this.groupBlacklist.stream().map(Pattern::toString).collect(Collectors.toList());
    }

    public List<String> getUserWhitelist() {
        return this.userWhitelist.stream().map(Pattern::toString).collect(Collectors.toList());
    }

    public List<String> getUserBlacklist() {
        return this.userBlacklist.stream().map(Pattern::toString).collect(Collectors.toList());
    }
}

