/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.samlsso.authenticator;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.login.JiraSeraphAuthenticator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.seraph.auth.AuthenticationContextAwareAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfig;
import de.resolution.samlsso.authenticator.ConfigurableDenyPasswordAuthenticator;
import de.resolution.samlsso.authenticator.DenyPasswordSupport;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthenticationContextAwareAuthenticator
public class JiraDenyPasswordAuthenticator
extends JiraSeraphAuthenticator
implements ConfigurableDenyPasswordAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(JiraDenyPasswordAuthenticator.class);
    private transient DenyPasswordSupport denyPasswordSupport;

    public void init(Map<String, String> params, SecurityConfig config) {
        super.init(params, config);
        this.denyPasswordSupport = new DenyPasswordSupport(params);
    }

    private boolean hasNoApplicationRole(@Nonnull String username) {
        UserManager userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        ApplicationUser applicationUser = userManager.getUserByName(username);
        if (applicationUser == null) {
            logger.warn("ApplicationUser is null!");
            return false;
        }
        ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentLocator.getComponent(ApplicationRoleManager.class);
        Set roles = applicationRoleManager.getRolesForUser(applicationUser);
        if (roles.isEmpty()) {
            logger.debug("User {} has no ApplicationRoles", (Object)username);
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} has the roles {}", (Object)username, (Object)roles.stream().map(ApplicationRole::getName).collect(Collectors.joining(",")));
        }
        return false;
    }

    public boolean authenticate(Principal principal, String password) throws AuthenticatorException {
        if (principal == null) {
            logger.error("Principal is null!");
            return false;
        }
        if (this.denyPasswordSupport.userOnBlacklist(principal.getName())) {
            logger.warn("Denying password access for principal {}, username is on the blacklist.", (Object)principal.getName());
            return false;
        }
        if (this.denyPasswordSupport.userOnWhitelist(principal.getName())) {
            return super.authenticate(principal, password);
        }
        if (this.denyPasswordSupport.isAllowWithoutApplicationAccess() && this.hasNoApplicationRole(principal.getName())) {
            return super.authenticate(principal, password);
        }
        GroupManager groupManager = (GroupManager)ComponentLocator.getComponent(GroupManager.class);
        Collection groups = groupManager.getGroupsForUser(principal.getName());
        if (this.denyPasswordSupport.groupAllowsPasswordLogin(groups.stream().map(Group::getName).collect(Collectors.toList()))) {
            return super.authenticate(principal, password);
        }
        if (!this.isAllowSysAdmins()) {
            logger.warn("Denying password access for principal {}", (Object)principal.getName());
            return false;
        }
        UserManager userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        ApplicationUser user = userManager.getUserByName(principal.getName());
        if (user == null) {
            logger.warn("Could not load ApplicationUser for {}, denying authentication.", (Object)principal.getName());
            return false;
        }
        GlobalPermissionManager permissionManager = (GlobalPermissionManager)ComponentLocator.getComponent(GlobalPermissionManager.class);
        if (permissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
            return super.authenticate(principal, password);
        }
        logger.warn("Denying password access for principal {}", (Object)principal.getName());
        return false;
    }

    @Override
    public DenyPasswordSupport getDenyPasswordSupport() {
        return this.denyPasswordSupport;
    }
}

